<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Spatie\Permission\Models\Role;

class RoleController extends Controller
{
    public function all(Request $request): Collection
    {
        return Role::all();
    }

    public function store(Request $request):JsonResource {
        $this->validate($request, [
            'name' => 'required|unique:roles,name',
            'permission' => 'required',
        ]);

        $permissionsID = array_map('intval', $request->input('permission'));

        $role = Role::create([
            'name' => $request->input('name'),
            'guard_name' => 'api',
        ]);
        $role->syncPermissions($permissionsID);

        return  $role->toResource();

    }

}
