<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Velo-Tick API Docs (v1)</title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <style>
        /* hide default triangle on summary */
        details summary::-webkit-details-marker { display: none; }
    </style>
</head>
<body class="bg-gray-100 text-gray-800 p-6">
<div class="max-w-6xl mx-auto space-y-4">
    <h1 class="text-3xl font-bold">Velo-Tick API Documentation (v1)</h1>

    <?php $__currentLoopData = $grouped; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag => $routes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <details class="bg-white shadow rounded-sm overflow-hidden">
            <summary class="cursor-pointer px-6 py-5 bg-gray-200 hover:bg-gray-300 flex justify-between items-center">
                <span class="font-medium uppercase"><?php echo e($tag); ?></span>
                <span class="text-sm text-gray-600"><?php echo e($routes->count()); ?> endpoint<?php echo e($routes->count() > 1 ? 's' : ''); ?></span>
            </summary>
            <div class="px-4 py-3">
                <table class="w-full text-left">
                    <thead class="border-b">
                    <tr>
                        <th class="py-2">Method</th>
                        <th class="py-2">URI</th>
                        <th class="py-2">Action</th>
                        <th class="py-2">Name</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $routes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="hover:bg-gray-50">
                            <td class="py-2">
                                <?php $__currentLoopData = $r['methods']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="inline-block px-2 py-1 mr-1 text-xs font-semibold text-white
                        <?php echo e($m==='GET' ? 'bg-blue-500'
                         : ($m==='POST' ? 'bg-green-500'
                         : ($m==='PATCH' ? 'bg-yellow-500' : 'bg-gray-500'))); ?>

                        rounded">
                        <?php echo e($m); ?>

                      </span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td class="py-2"><code>/<?php echo e($r['uri']); ?></code></td>
                            <td class="py-2"><small><?php echo e(class_basename($r['action'])); ?></small></td>
                            <td class="py-2"><small><?php echo e($r['name'] ?? '–'); ?></small></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </details>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</div>
</body>
</html>
<?php /**PATH C:\Users\HP\Documents\velo-tick-flutter-laravel\backend\resources\views/welcome.blade.php ENDPATH**/ ?>